/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Config {
    private static boolean exists = false;
    private Document myDomDoc;
    private final String myFilename = "Config.xml";
    private File myCfgFile;
    private static Config theConfig = null;

    private Config() {
        exists = true;
        this.myCfgFile = new File("Config.xml");
        this.readConfig();
    }

    public static Config getConfig() {
        if (!exists) {
            theConfig = new Config();
        }
        return theConfig;
    }

    private void readConfig() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.myDomDoc = builder.parse(this.myCfgFile);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Cannot read Config.xml " + e);
        }
    }

    public String getParam(String name) {
        String result = "";
        Element rootElement = this.myDomDoc.getDocumentElement();
        Node n = rootElement.getFirstChild();
        boolean found = false;
        while (!found && n != null) {
            if (n.getNodeName() == name) {
                found = true;
                result = n.getTextContent();
            }
            n = n.getNextSibling();
        }
        if (!found) {
            JOptionPane.showMessageDialog(null, "Cannot read Config for " + name);
        }
        return result;
    }

    public int getParamToInt(String name) {
        String val = this.getParam(name);
        int result = 0;
        try {
            result = Integer.parseInt(val);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Cannot convert to int " + e);
        }
        return result;
    }

    public double getParamToDouble(String name) {
        String val = this.getParam(name);
        double result = 1.0;
        try {
            result = Double.valueOf(val);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Cannot convert to double " + e);
        }
        return result;
    }

    public void setParam(String name, String value) {
        Element rootElement = this.myDomDoc.getDocumentElement();
        Node n = rootElement.getFirstChild();
        boolean found = false;
        while (!found && n != null) {
            if (n.getNodeName() == name) {
                found = true;
                n.setTextContent(value);
            }
            n = n.getNextSibling();
        }
        if (!found) {
            JOptionPane.showMessageDialog(null, "Cannot write Config for " + name);
        }
    }

    public void writeConfig() {
        try {
            TransformerFactory tranFactory = TransformerFactory.newInstance();
            Transformer aTransformer = tranFactory.newTransformer();
            DOMSource src = new DOMSource(this.myDomDoc);
            StreamResult dest = new StreamResult(this.myCfgFile);
            aTransformer.transform(src, dest);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Config.writeConfig " + e);
        }
    }
}

